"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unwrapValue = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Unpacks field value from raw indicator fields. Will return null if fields are missing entirely
 * or there is no record for given `fieldId`
 */
const unwrapValue = (indicator, fieldId) => {
  var _indicator$fields;
  if (!indicator) {
    return null;
  }
  const fieldValues = (_indicator$fields = indicator.fields) === null || _indicator$fields === void 0 ? void 0 : _indicator$fields[fieldId];
  if (!Array.isArray(fieldValues)) {
    return null;
  }
  const firstValue = fieldValues[0];
  return typeof firstValue === 'object' ? null : firstValue;
};
exports.unwrapValue = unwrapValue;