"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFetchIndicators = void 0;
var _constants = require("../../../../common/constants");
var _get_indicator_query_params = require("../utils/get_indicator_query_params");
var _search = require("../../../utils/search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFetchIndicators = ({
  searchService,
  inspectorAdapter
}) => async ({
  pagination,
  selectedPatterns,
  timeRange,
  filterQuery,
  filters,
  sorting
}, signal) => {
  const sharedParams = (0, _get_indicator_query_params.getIndicatorQueryParams)({
    timeRange,
    filters,
    filterQuery
  });
  const searchRequestBody = {
    size: pagination.pageSize,
    from: pagination.pageIndex,
    fields: [{
      field: '*',
      include_unmapped: true
    }],
    sort: sorting.map(({
      id,
      direction
    }) => ({
      [id]: direction
    })),
    ...sharedParams
  };
  const {
    hits: {
      hits: indicators,
      total
    }
  } = await (0, _search.search)(searchService, {
    params: {
      index: selectedPatterns,
      body: searchRequestBody
    },
    factoryQueryType: _constants.FactoryQueryType.IndicatorGrid
  }, {
    inspectorAdapter,
    requestName: 'Indicators table',
    signal
  });
  return {
    indicators,
    total
  };
};
exports.createFetchIndicators = createFetchIndicators;