"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolbarOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_inspector = require("../../../hooks/use_inspector");
var _field_browser = require("../components/table/field_browser");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToolbarOptions = ({
  browserFields,
  start,
  end,
  indicatorCount,
  columns,
  onResetColumns,
  onToggleColumn
}) => {
  const {
    onOpenInspector: handleOpenInspector
  } = (0, _use_inspector.useInspector)();
  return (0, _react.useMemo)(() => ({
    showDisplaySelector: false,
    showFullScreenSelector: true,
    additionalControls: {
      left: {
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          style: {
            display: 'inline'
          },
          size: "xs"
        }, indicatorCount && end ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "Showing ", start + 1, "-", end > indicatorCount ? indicatorCount : end, " of", ' ', indicatorCount, " indicators") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "-")),
        append: /*#__PURE__*/_react.default.createElement(_field_browser.IndicatorsFieldBrowser, {
          browserFields: browserFields,
          columnIds: columns.map(({
            id
          }) => id),
          onResetColumns: onResetColumns,
          onToggleColumn: onToggleColumn
        })
      },
      right: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _translations.INSPECT_BUTTON_TITLE,
        iconType: "inspect",
        title: _translations.INSPECT_BUTTON_TITLE,
        "data-test-subj": _test_ids.INSPECT_BUTTON_TEST_ID,
        onClick: handleOpenInspector
      })
    }
  }), [indicatorCount, end, start, browserFields, columns, onResetColumns, onToggleColumn, handleOpenInspector]);
};
exports.useToolbarOptions = useToolbarOptions;