"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorBlock = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _field_value = require("../common/field_value");
var _field_label = require("../common/field_label");
var _indicator_value_actions = require("./indicator_value_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Show actions wrapper on hover. This is a helper component, limited only to Block
 */
const VisibleOnHover = _common.euiStyled.div`
  ${({
  theme
}) => (0, _common.css)`
    & {
      height: 100%;
    }

    & .actionsWrapper {
      visibility: hidden;
      display: inline-block;
      margin-inline-start: ${theme.eui.euiSizeS};
    }

    &:hover .actionsWrapper {
      visibility: visible;
    }
  `}
`;
const panelProps = {
  color: 'subdued',
  hasShadow: false,
  borderRadius: 'none',
  paddingSize: 's'
};
/**
 * Renders indicator field value in a rectangle, to highlight it even more
 */
const IndicatorBlock = ({
  field,
  indicator,
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, panelProps, /*#__PURE__*/_react.default.createElement(VisibleOnHover, {
    "data-test-subj": `${dataTestSubj}Item`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_field_label.IndicatorFieldLabel, {
    field: field
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_field_value.IndicatorFieldValue, {
    indicator: indicator,
    field: field
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "actionsWrapper"
  }, /*#__PURE__*/_react.default.createElement(_indicator_value_actions.IndicatorValueActions, {
    indicator: indicator,
    field: field,
    "data-test-subj": dataTestSubj
  })))));
};
exports.IndicatorBlock = IndicatorBlock;