"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TYPE = exports.TLP_MARKETING = exports.TIMESTAMP = exports.LAST_SEEN = exports.INDICATORS = exports.FIRST_SEEN = exports.FEED = exports.COPY_TITLE = exports.CONFIDENCE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* Copy To Clipboard */
const COPY_TITLE = exports.COPY_TITLE = _i18n.i18n.translate('xpack.threatIntelligence.indicators.table.copyToClipboardLabel', {
  defaultMessage: 'Copy to clipboard'
});

/* Field Label */

const TIMESTAMP = exports.TIMESTAMP = _i18n.i18n.translate('xpack.threatIntelligence.field.@timestamp', {
  defaultMessage: '@timestamp'
});
const INDICATORS = exports.INDICATORS = _i18n.i18n.translate('xpack.threatIntelligence.field.threat.indicator.name', {
  defaultMessage: 'Indicator'
});
const TYPE = exports.TYPE = _i18n.i18n.translate('xpack.threatIntelligence.field.threat.indicator.type', {
  defaultMessage: 'Indicator type'
});
const FEED = exports.FEED = _i18n.i18n.translate('xpack.threatIntelligence.field.threat.feed.name', {
  defaultMessage: 'Feed'
});
const FIRST_SEEN = exports.FIRST_SEEN = _i18n.i18n.translate('xpack.threatIntelligence.field.threat.indicator.first_seen', {
  defaultMessage: 'First seen'
});
const LAST_SEEN = exports.LAST_SEEN = _i18n.i18n.translate('xpack.threatIntelligence.field.threat.indicator.last_seen', {
  defaultMessage: 'Last seen'
});
const CONFIDENCE = exports.CONFIDENCE = _i18n.i18n.translate('xpack.threatIntelligence.field.threat.indicator.confidence', {
  defaultMessage: 'Confidence'
});
const TLP_MARKETING = exports.TLP_MARKETING = _i18n.i18n.translate('xpack.threatIntelligence.field.threat.indicator.marking.tlp', {
  defaultMessage: 'TLP Marking'
});