"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateFormatter = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _common = require("../constants/common");
var _dates = require("../utils/dates");
var _use_kibana_ui_settings = require("../hooks/use_kibana_ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

_moment.default.suppressDeprecationWarnings = true;
const DateFormatter = ({
  date,
  dateFormat
}) => {
  const userTimeZone = (0, _use_kibana_ui_settings.useTimeZone)();
  const userFormat = (0, _use_kibana_ui_settings.useDateFormat)();
  if (date === null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _common.EMPTY_VALUE);
  const momentDate = typeof date === 'string' ? (0, _moment.default)(date) : date;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _dates.dateFormatter)(momentDate, userTimeZone, dateFormat || userFormat));
};
exports.DateFormatter = DateFormatter;