"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateTelemetrySavedObject = updateTelemetrySavedObject;
var _server = require("@kbn/core/server");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function updateTelemetrySavedObject(savedObjectsClient, savedObjectAttributes) {
  try {
    return await savedObjectsClient.update(_constants.TELEMETRY_SAVED_OBJECT_TYPE, _constants.TELEMETRY_SAVED_OBJECT_ID, savedObjectAttributes);
  } catch (err) {
    if (_server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
      return await savedObjectsClient.create(_constants.TELEMETRY_SAVED_OBJECT_TYPE, savedObjectAttributes, {
        id: _constants.TELEMETRY_SAVED_OBJECT_ID,
        overwrite: true
      });
    }
    throw err;
  }
}