"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseSubscriber = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LicenseSubscriber {
  constructor(license) {
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "licenseState", void 0);
    this.getIsSecurityEnabled = this.getIsSecurityEnabled.bind(this);
    this.updateState = this.updateState.bind(this);
    this.subscription = license.subscribe(this.updateState);
  }
  updateState(license) {
    this.licenseState = license;
  }
  getIsSecurityEnabled() {
    if (!this.licenseState || !this.licenseState.isAvailable) {
      return false;
    }
    return this.licenseState.getFeature('security').isEnabled;
  }
  cleanup() {
    this.subscription.unsubscribe();
  }
}
exports.LicenseSubscriber = LicenseSubscriber;