"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNodeRecord = exports.createFindSO = exports.createFindResponse = exports.createDiscoveryServiceMock = void 0;
var _mocks = require("@kbn/core/server/mocks");
var _saved_objects = require("../saved_objects");
var _kibana_discovery_service = require("./kibana_discovery_service");
var _config = require("../config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDiscoveryServiceMock = currentNode => {
  const savedObjectsRepository = _mocks.savedObjectsRepositoryMock.create();
  const logger = _mocks.loggingSystemMock.createLogger();
  const discoveryService = new _kibana_discovery_service.KibanaDiscoveryService({
    savedObjectsRepository,
    logger,
    currentNode,
    config: {
      active_nodes_lookback: _config.DEFAULT_ACTIVE_NODES_LOOK_BACK_DURATION,
      interval: _config.DEFAULT_DISCOVERY_INTERVAL_MS
    }
  });
  for (const method of ['getActiveKibanaNodes']) {
    jest.spyOn(discoveryService, method);
  }
  return discoveryService;
};
exports.createDiscoveryServiceMock = createDiscoveryServiceMock;
const createNodeRecord = (id, lastSeen) => ({
  id,
  last_seen: lastSeen
});
exports.createNodeRecord = createNodeRecord;
const createFindSO = (id, lastSeen) => ({
  attributes: createNodeRecord(id, lastSeen),
  id: `${_saved_objects.BACKGROUND_TASK_NODE_SO_NAME}:${id}`,
  namespaces: ['default'],
  references: [],
  score: 1,
  type: _saved_objects.BACKGROUND_TASK_NODE_SO_NAME,
  updated_at: new Date().toDateString(),
  version: '1'
});
exports.createFindSO = createFindSO;
const createFindResponse = soList => ({
  total: 1,
  per_page: 10000,
  page: 1,
  saved_objects: soList
});
exports.createFindResponse = createFindResponse;