"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.icmpFormatters = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _formatting_utils = require("./formatting_utils");
var _common_formatters = require("./common_formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const icmpFormatters = exports.icmpFormatters = {
  ..._common_formatters.commonFormatters,
  [_runtime_types.ConfigKey.HOSTS]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.WAIT]: _formatting_utils.secondsToCronFormatter,
  [_runtime_types.ConfigKey.MODE]: null,
  [_runtime_types.ConfigKey.IPV4]: null,
  [_runtime_types.ConfigKey.IPV6]: null
};