"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegacySyntheticsMonitorSavedObjectType = exports.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE_SINGLE = exports.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE = void 0;
var _i18n = require("@kbn/i18n");
var _synthetics_monitor_config = require("./synthetics_monitor_config");
var _monitor_mappings = require("./monitor_mappings");
var _saved_objects = require("../../../common/types/saved_objects");
var _monitor_management = require("../../../common/constants/monitor_management");
var _monitors = require("../migrations/monitors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE_SINGLE = exports.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE_SINGLE = {
  type: _saved_objects.legacySyntheticsMonitorTypeSingle,
  attributesToEncrypt: new Set(['secrets',
  /* adding secretKeys to the list of attributes to encrypt ensures
   * that secrets are never stored on the resulting saved object,
   * even in the presence of developer error.
   *
   * In practice, all secrets should be stored as a single JSON
   * payload on the `secrets` key. This ensures performant decryption. */
  ..._monitor_management.secretKeys]),
  attributesToIncludeInAAD: _synthetics_monitor_config.attributesToIncludeInAAD
};
const getLegacySyntheticsMonitorSavedObjectType = encryptedSavedObjects => {
  return {
    name: _saved_objects.legacySyntheticsMonitorTypeSingle,
    hidden: false,
    namespaceType: 'single',
    migrations: {
      '8.6.0': _monitors.monitorMigrations['8.6.0'](encryptedSavedObjects),
      '8.8.0': _monitors.monitorMigrations['8.8.0'](encryptedSavedObjects),
      '8.9.0': _monitors.monitorMigrations['8.9.0'](encryptedSavedObjects)
    },
    mappings: _monitor_mappings.monitorConfigMappings,
    management: {
      importableAndExportable: false,
      icon: 'uptimeApp',
      getTitle: savedObject => _i18n.i18n.translate('xpack.synthetics.syntheticsMonitors.label.name', {
        defaultMessage: '{name} - Synthetics - Monitor',
        values: {
          name: savedObject.attributes.name
        }
      })
    },
    modelVersions: {
      '1': {
        changes: [{
          type: 'mappings_addition',
          addedMappings: {
            config_id: {
              type: 'keyword'
            }
          }
        }]
      },
      '2': {
        changes: [{
          type: 'mappings_addition',
          addedMappings: {
            maintenance_windows: {
              type: 'keyword'
            }
          }
        }]
      }
    }
  };
};
exports.getLegacySyntheticsMonitorSavedObjectType = getLegacySyntheticsMonitorSavedObjectType;
const LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE = exports.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE = {
  type: _saved_objects.legacySyntheticsMonitorTypeSingle,
  attributesToEncrypt: new Set(['secrets',
  /* adding secretKeys to the list of attributes to encrypt ensures
   * that secrets are never stored on the resulting saved object,
   * even in the presence of developer error.
   *
   * In practice, all secrets should be stored as a single JSON
   * payload on the `secrets` key. This ensures performant decryption. */
  ..._monitor_management.secretKeys]),
  attributesToIncludeInAAD: new Set([_monitor_management.LegacyConfigKey.SOURCE_ZIP_URL, _monitor_management.LegacyConfigKey.SOURCE_ZIP_USERNAME, _monitor_management.LegacyConfigKey.SOURCE_ZIP_PASSWORD, _monitor_management.LegacyConfigKey.SOURCE_ZIP_FOLDER, _monitor_management.LegacyConfigKey.SOURCE_ZIP_PROXY_URL, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_CERTIFICATE_AUTHORITIES, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_CERTIFICATE, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_KEY, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_KEY_PASSPHRASE, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_VERIFICATION_MODE, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_VERSION, _monitor_management.LegacyConfigKey.THROTTLING_CONFIG, _monitor_management.LegacyConfigKey.IS_THROTTLING_ENABLED, _monitor_management.LegacyConfigKey.DOWNLOAD_SPEED, _monitor_management.LegacyConfigKey.UPLOAD_SPEED, _monitor_management.LegacyConfigKey.LATENCY, ..._synthetics_monitor_config.attributesToIncludeInAAD])
};