"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateLegacyPrivateLocations = void 0;
var _private_locations = require("../../../../common/saved_objects/private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateLegacyPrivateLocations = async (soClient, logger) => {
  try {
    var _obj$attributes$locat, _obj;
    let obj;
    try {
      obj = await soClient.get(_private_locations.legacyPrivateLocationsSavedObjectName, _private_locations.legacyPrivateLocationsSavedObjectId);
    } catch (e) {
      // we don't need to do anything if the legacy object doesn't exist
      return;
    }
    const legacyLocations = (_obj$attributes$locat = (_obj = obj) === null || _obj === void 0 ? void 0 : _obj.attributes.locations) !== null && _obj$attributes$locat !== void 0 ? _obj$attributes$locat : [];
    if (legacyLocations.length === 0) {
      return;
    }
    await soClient.bulkCreate(legacyLocations.map(location => ({
      id: location.id,
      attributes: location,
      type: _private_locations.privateLocationSavedObjectName,
      initialNamespaces: ['*']
    })), {
      overwrite: true
    });
    const {
      total
    } = await soClient.find({
      type: _private_locations.privateLocationSavedObjectName,
      fields: [],
      perPage: 0,
      namespaces: ['*']
    });
    if (total === legacyLocations.length) {
      await soClient.delete(_private_locations.legacyPrivateLocationsSavedObjectName, _private_locations.legacyPrivateLocationsSavedObjectId, {});
    }
  } catch (error) {
    logger.error(`Error migrating legacy private locations: ${error.message}`, {
      error
    });
  }
};
exports.migrateLegacyPrivateLocations = migrateLegacyPrivateLocations;