"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSyntheticsParamsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _sync_private_locations_monitors_task = require("../../../tasks/sync_private_locations_monitors_task");
var _saved_objects = require("../../../../common/types/saved_objects");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSyntheticsParamsRoute = () => ({
  method: 'DELETE',
  path: _constants.SYNTHETICS_API_URLS.PARAMS + '/{id?}',
  validate: {},
  validation: {
    request: {
      body: _configSchema.schema.nullable(_configSchema.schema.object({
        ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
          minSize: 1
        })
      })),
      params: _configSchema.schema.object({
        id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  },
  handler: async ({
    savedObjectsClient,
    request,
    response,
    server
  }) => {
    var _request$body, _request$params;
    const {
      ids
    } = (_request$body = request.body) !== null && _request$body !== void 0 ? _request$body : {};
    const {
      id: paramId
    } = (_request$params = request.params) !== null && _request$params !== void 0 ? _request$params : {};
    if (ids && paramId) {
      return response.badRequest({
        body: _i18n.i18n.translate('xpack.synthetics.deleteParam.errorMultipleIdsProvided', {
          defaultMessage: `Both param id  and body parameters cannot be provided`
        })
      });
    }
    const idsToDelete = ids !== null && ids !== void 0 ? ids : [paramId];
    if (idsToDelete.length === 0) {
      return response.badRequest({
        body: _i18n.i18n.translate('xpack.synthetics.deleteParam.errorNoIdsProvided', {
          defaultMessage: `No param ids provided`
        })
      });
    }
    const result = await savedObjectsClient.bulkDelete(idsToDelete.map(id => ({
      type: _saved_objects.syntheticsParamType,
      id
    })), {
      force: true
    });
    await (0, _sync_private_locations_monitors_task.runSynPrivateLocationMonitorsTaskSoon)({
      server
    });
    return result.statuses.map(({
      id,
      success
    }) => ({
      id,
      deleted: success
    }));
  }
});
exports.deleteSyntheticsParamsRoute = deleteSyntheticsParamsRoute;