"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSpaceId = void 0;
var _common = require("@kbn/spaces-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateSpaceId = async routeContext => {
  var _await$server$spaces$, _server$spaces;
  const {
    server,
    request,
    spaceId
  } = routeContext;
  // If the spaceId is the default space, return it, it always exists
  if (spaceId === _common.DEFAULT_SPACE_ID) {
    return spaceId;
  }
  const {
    id
  } = (_await$server$spaces$ = await ((_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.getActiveSpace(request))) !== null && _await$server$spaces$ !== void 0 ? _await$server$spaces$ : {
    id: _common.DEFAULT_SPACE_ID
  };
  return id;
};
exports.validateSpaceId = validateSpaceId;