"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inspectSyntheticsMonitorRoute = void 0;
var _uuid = require("uuid");
var _configSchema = require("@kbn/config-schema");
var _unzipt_project_code = require("../../common/unzipt_project_code");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
var _monitor_defaults = require("../../../common/constants/monitor_defaults");
var _monitor_validation = require("./monitor_validation");
var _utils = require("./add_monitor/utils");
var _add_monitor_api = require("./add_monitor/add_monitor_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inspectSyntheticsMonitorRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITOR_INSPECT,
  validate: {
    body: _configSchema.schema.any(),
    query: _configSchema.schema.object({
      id: _configSchema.schema.maybe(_configSchema.schema.string()),
      hideParams: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })
  },
  handler: async routeContext => {
    var _Boolean, _server$coreStart;
    const {
      savedObjectsClient,
      server,
      syntheticsMonitorClient,
      request,
      spaceId,
      response
    } = routeContext;
    // usually id is auto generated, but this is useful for testing
    const {
      id,
      hideParams = true
    } = request.query;
    const monitor = request.body;
    const monitorType = monitor[_runtime_types.ConfigKey.MONITOR_TYPE];
    const monitorWithDefaults = {
      ..._monitor_defaults.DEFAULT_FIELDS[monitorType],
      ...monitor
    };
    const validationResult = (0, _monitor_validation.validateMonitor)(monitorWithDefaults, spaceId);
    if (!validationResult.valid || !validationResult.decodedMonitor) {
      const {
        reason: message,
        details,
        payload
      } = validationResult;
      return response.badRequest({
        body: {
          message,
          attributes: {
            details,
            ...payload
          }
        }
      });
    }
    const normalizedMonitor = validationResult.decodedMonitor;
    const privateLocations = await (0, _utils.getPrivateLocationsForMonitor)(savedObjectsClient, normalizedMonitor);
    const canSave = (_Boolean = Boolean((await ((_server$coreStart = server.coreStart) === null || _server$coreStart === void 0 ? void 0 : _server$coreStart.capabilities.resolveCapabilities(request, {
      capabilityPath: 'uptime.*'
    }))).uptime.save)) !== null && _Boolean !== void 0 ? _Boolean : false;
    try {
      var _publicConfigs$, _publicConfigs$$monit;
      const newMonitorId = id || normalizedMonitor.config_id || (0, _uuid.v4)();
      const addMonitorAPI = new _add_monitor_api.AddEditMonitorAPI(routeContext);
      const monitorWithNamespace = addMonitorAPI.hydrateMonitorFields({
        normalizedMonitor,
        newMonitorId
      });
      const result = await syntheticsMonitorClient.inspectMonitor({
        monitor: monitorWithNamespace,
        id: newMonitorId
      }, privateLocations, spaceId, hideParams, canSave);
      const publicConfigs = result.publicConfigs;
      const sampleMonitor = publicConfigs === null || publicConfigs === void 0 ? void 0 : (_publicConfigs$ = publicConfigs[0]) === null || _publicConfigs$ === void 0 ? void 0 : (_publicConfigs$$monit = _publicConfigs$.monitors) === null || _publicConfigs$$monit === void 0 ? void 0 : _publicConfigs$$monit[0];
      const hasSourceContent = sampleMonitor === null || sampleMonitor === void 0 ? void 0 : sampleMonitor.streams[0][_runtime_types.ConfigKey.SOURCE_PROJECT_CONTENT];
      let decodedCode = '';
      if (hasSourceContent) {
        decodedCode = await (0, _unzipt_project_code.unzipFile)(hasSourceContent);
      }
      return response.ok({
        body: {
          result,
          decodedCode: formatCode(decodedCode)
        }
      });
    } catch (error) {
      server.logger.error(`Unable to inspect Synthetics monitor ${monitorWithDefaults[_runtime_types.ConfigKey.NAME]}`, {
        error
      });
      return response.customError({
        body: {
          message: error.message
        },
        statusCode: 500
      });
    }
  }
});
exports.inspectSyntheticsMonitorRoute = inspectSyntheticsMonitorRoute;
const formatCode = code => {
  const replacements = [{
    pattern: /\(\d*,\s*import_synthetics\d*\.step\)/g,
    replacement: 'step'
  }, {
    pattern: /\(\d*,\s*import_synthetics\d*\.journey\)/g,
    replacement: 'journey'
  }, {
    pattern: /import_synthetics\d*\.monitor/g,
    replacement: 'monitor'
  }, {
    pattern: /\(\d*,\s*import_synthetics\d*\.expect\)/g,
    replacement: 'expect'
  }];
  let updated = code;
  replacements.forEach(({
    pattern,
    replacement
  }) => {
    updated = updated.replace(pattern, replacement);
  });
  return updated.replace(/var import_synthetics\d* = require\("@elastic\/synthetics"\);/, "import { step, journey, monitor, expect } from '@elastic/synthetics';").replace(/var import_synthetics = require\("@elastic\/synthetics"\);/, "import { step, journey, monitor, expect } from '@elastic/synthetics';");
};