"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _ebtTools = require("@kbn/ebt-tools");
var _synthetics_shared_context = require("./contexts/synthetics_shared_context");
var _kibana_service = require("../../utils/kibana_service");
var _action_menu = require("./components/common/header/action_menu");
var _test_now_mode_flyout_container = require("./components/test_now_mode/test_now_mode_flyout_container");
var _contexts = require("./contexts");
var _routes = require("./routes");
var _state = require("./state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Application = props => {
  const {
    basePath,
    canSave,
    coreStart,
    renderGlobalHelpControls,
    setBadge,
    appMountParameters
  } = props;
  (0, _react.useEffect)(() => {
    renderGlobalHelpControls();
    setBadge(!canSave ? {
      text: _i18n.i18n.translate('xpack.synthetics.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('xpack.synthetics.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to save'
      }),
      iconType: 'glasses'
    } : undefined);
  }, [canSave, renderGlobalHelpControls, setBadge]);
  _kibana_service.kibanaService.theme = props.appMountParameters.theme$;
  _state.store.dispatch((0, _state.setBasePath)(basePath));
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: coreStart.theme,
    modify: {
      breakpoint: {
        xxl: 1600,
        xxxl: 2000
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
    analytics: coreStart.analytics
  }, /*#__PURE__*/_react.default.createElement(_synthetics_shared_context.SyntheticsSharedContext, props, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: appMountParameters.history
  }, /*#__PURE__*/_react.default.createElement(_contexts.SyntheticsSettingsContextProvider, props, /*#__PURE__*/_react.default.createElement(_ebtTools.PerformanceContextProvider, null, /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": "syntheticsApp"
  }, /*#__PURE__*/_react.default.createElement(_public2.InspectorContextProvider, null, /*#__PURE__*/_react.default.createElement(_routes.PageRouter, null), /*#__PURE__*/_react.default.createElement(_action_menu.ActionMenu, {
    appMountParameters: appMountParameters
  }), /*#__PURE__*/_react.default.createElement(_test_now_mode_flyout_container.TestNowModeFlyoutContainer, null))))))))));
};
const SyntheticsApp = props => /*#__PURE__*/_react.default.createElement(Application, props);
exports.SyntheticsApp = SyntheticsApp;