"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAsyncAction = createAsyncAction;
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createAsyncAction(actionStr) {
  return {
    get: (0, _toolkit.createAction)(actionStr, payload => prepareForTimestamp(payload)),
    success: (0, _toolkit.createAction)(`${actionStr}_SUCCESS`),
    fail: (0, _toolkit.createAction)(`${actionStr}_FAIL`)
  };
}
// Action prepare function which adds meta.dispatchedAt timestamp to the action
function prepareForTimestamp(payload) {
  return {
    payload,
    meta: {
      dispatchedAt: Date.now()
    }
  };
}