"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  uiReducer: true
};
exports.uiReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isNewRuleFlyout: false,
  ruleFlyoutVisible: null,
  basePath: '',
  esKuery: '',
  searchText: '',
  integrationsPopoverOpen: null,
  monitorId: ''
};
const uiReducer = exports.uiReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.toggleIntegrationsPopover, (state, action) => {
    state.integrationsPopoverOpen = action.payload;
  }).addCase(_actions.setAlertFlyoutVisible, (state, action) => {
    var _action$payload$id, _action$payload, _action$payload$isNew, _action$payload2;
    state.ruleFlyoutVisible = (_action$payload$id = (_action$payload = action.payload) === null || _action$payload === void 0 ? void 0 : _action$payload.id) !== null && _action$payload$id !== void 0 ? _action$payload$id : null;
    state.isNewRuleFlyout = (_action$payload$isNew = (_action$payload2 = action.payload) === null || _action$payload2 === void 0 ? void 0 : _action$payload2.isNewRuleFlyout) !== null && _action$payload$isNew !== void 0 ? _action$payload$isNew : null;
  }).addCase(_actions.setBasePath, (state, action) => {
    state.basePath = action.payload;
  }).addCase(_actions.setEsKueryString, (state, action) => {
    state.esKuery = action.payload;
  }).addCase(_actions.setSearchTextAction, (state, action) => {
    state.searchText = action.payload;
  }).addCase(_actions.setSelectedMonitorId, (state, action) => {
    state.monitorId = action.payload;
  });
});