"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchManualTestRunsEffect = fetchManualTestRunsEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _fetch_effect = require("../utils/fetch_effect");
var _actions = require("./actions");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchManualTestRunsEffect() {
  yield (0, _effects.takeEvery)(_actions.manualTestMonitorAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.triggerTestNowMonitor, _actions.manualTestMonitorAction.success, _actions.manualTestMonitorAction.fail, '', FAILED_TEST));
}
const FAILED_TEST = _i18n.i18n.translate('xpack.synthetics.runTest.failure', {
  defaultMessage: 'Failed to run test manually'
});