"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalParams = exports.editGlobalParam = exports.deleteGlobalParams = exports.addGlobalParam = void 0;
var _lodash = require("lodash");
var _constants = require("../../../../../common/constants");
var _runtime_types = require("../../../../../common/runtime_types");
var _api_service = require("../../../../utils/api_service/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGlobalParams = async () => {
  return _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PARAMS, {
    version: _constants.INITIAL_REST_VERSION
  }, _runtime_types.SyntheticsParamsReadonlyCodecList);
};
exports.getGlobalParams = getGlobalParams;
const addGlobalParam = async paramRequest => _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.PARAMS, paramRequest, _runtime_types.SyntheticsParamsReadonlyCodec, {
  version: _constants.INITIAL_REST_VERSION
});
exports.addGlobalParam = addGlobalParam;
const editGlobalParam = async ({
  paramRequest,
  id
}) => {
  const data = paramRequest;
  if ((0, _lodash.isEmpty)(paramRequest.value)) {
    // omit empty value
    delete data.value;
  }
  return await _api_service.apiService.put(_constants.SYNTHETICS_API_URLS.PARAMS + `/${id}`, data, _runtime_types.SyntheticsParamsCodec, {
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.editGlobalParam = editGlobalParam;
const deleteGlobalParams = async ids => {
  return await _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.PARAMS + '/_bulk_delete', {
    ids
  }, null, {
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.deleteGlobalParams = deleteGlobalParams;