"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateHitCountsAction = exports.setBlockLoadingAction = exports.putCacheSize = exports.putBlocksAction = exports.pruneCacheAction = exports.fetchJourneyAction = exports.fetchBlocksAction = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("../utils/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This action denotes a set of blocks is required
const fetchBlocksAction = exports.fetchBlocksAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] FETCH BLOCKS');

// This action denotes a request for a set of blocks is in flight
const setBlockLoadingAction = exports.setBlockLoadingAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] SET BLOCKS IN FLIGHT');

// Block data has been received, and should be added to the store
const putBlocksAction = exports.putBlocksAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] PUT SCREENSHOT BLOCKS');

// Updates the total size of the image blob data cached in the store
const putCacheSize = exports.putCacheSize = (0, _toolkit.createAction)('[BROWSER JOURNEY] PUT CACHE SIZE');

// Keeps track of the most-requested blocks
const updateHitCountsAction = exports.updateHitCountsAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] UPDATE HIT COUNTS');

// Reduce the cache size to the value in the action payload
const pruneCacheAction = exports.pruneCacheAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] PRUNE SCREENSHOT BLOCK CACHE');
const fetchJourneyAction = exports.fetchJourneyAction = (0, _actions.createAsyncAction)('fetchJourneyStepsAction');