"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigStatusByLocation = void 0;
exports.useStatusByLocationOverview = useStatusByLocationOverview;
var _reactRedux = require("react-redux");
var _overview_status = require("../state/overview_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStatusByLocationOverview({
  configId,
  locationId
}) {
  const {
    status
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  return getConfigStatusByLocation(status, configId, locationId);
}
const getConfigStatusByLocation = (status, configId, locationId) => {
  if (!status) {
    return {
      status: 'unknown'
    };
  }
  const configIdByLocation = `${configId}-${locationId}`;
  const config = status.upConfigs[configIdByLocation] || status.downConfigs[configIdByLocation];
  return {
    configIdByLocation,
    status: (config === null || config === void 0 ? void 0 : config.status) || 'unknown',
    timestamp: config === null || config === void 0 ? void 0 : config.timestamp
  };
};
exports.getConfigStatusByLocation = getConfigStatusByLocation;