"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyout = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFlyout = metadata => {
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [flyoutData, setFlyoutData] = (0, _react.useState)(undefined);
  const [currentSidebarItemRef, setCurrentSidebarItemRef] = (0, _react.useState)();
  const handleFlyout = (0, _react.useCallback)(flyoutEntry => {
    setFlyoutData(flyoutEntry);
    setIsFlyoutVisible(true);
  }, [setIsFlyoutVisible, setFlyoutData]);
  const onFlyoutClose = (0, _react.useCallback)(() => {
    var _currentSidebarItemRe;
    setIsFlyoutVisible(false);
    currentSidebarItemRef === null || currentSidebarItemRef === void 0 ? void 0 : (_currentSidebarItemRe = currentSidebarItemRef.current) === null || _currentSidebarItemRe === void 0 ? void 0 : _currentSidebarItemRe.focus();
  }, [currentSidebarItemRef, setIsFlyoutVisible]);
  const onBarClick = (0, _react.useCallback)(([elementData]) => {
    setIsFlyoutVisible(false);
    const {
      datum
    } = elementData[0];
    const metadataEntry = metadata[datum.config.id];
    handleFlyout(metadataEntry);
  }, [metadata, handleFlyout]);
  const onProjectionClick = (0, _react.useCallback)(projectionData => {
    setIsFlyoutVisible(false);
    const {
      x
    } = projectionData;
    if (typeof x === 'number' && x >= 0) {
      const metadataEntry = metadata[x];
      handleFlyout(metadataEntry);
    }
  }, [metadata, handleFlyout]);
  const onSidebarClick = (0, _react.useCallback)(({
    buttonRef,
    networkItemIndex
  }) => {
    if (isFlyoutVisible && buttonRef === currentSidebarItemRef) {
      setIsFlyoutVisible(false);
    } else {
      const metadataEntry = metadata[networkItemIndex];
      setCurrentSidebarItemRef(buttonRef);
      handleFlyout(metadataEntry);
    }
  }, [currentSidebarItemRef, handleFlyout, isFlyoutVisible, metadata, setIsFlyoutVisible]);
  return {
    flyoutData,
    onBarClick,
    onProjectionClick,
    onSidebarClick,
    isFlyoutVisible,
    onFlyoutClose
  };
};
exports.useFlyout = useFlyout;