"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreakdownLegend = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _thershold_indicator = require("../../common/components/thershold_indicator");
var _use_network_timings_prev = require("../hooks/use_network_timings_prev");
var _data_formatting = require("../common/network_data/data_formatting");
var _use_network_timings = require("../hooks/use_network_timings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BreakdownLegend = () => {
  const networkTimings = (0, _use_network_timings.useNetworkTimings)();
  const {
    timingsWithLabels: prevTimingsWithLabels,
    loading
  } = (0, _use_network_timings_prev.useNetworkTimingsPrevious24Hours)();
  const theme = (0, _public.useTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, networkTimings.timingsWithLabels.map(({
    label,
    value
  }, index) => {
    const prevValueItem = prevTimingsWithLabels === null || prevTimingsWithLabels === void 0 ? void 0 : prevTimingsWithLabels.find(prev => prev.label === label);
    const prevValue = prevValueItem === null || prevValueItem === void 0 ? void 0 : prevValueItem.value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: index,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: theme.eui[`euiColorVis${index + 1}`]
    }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        minWidth: 50
      }
    }, /*#__PURE__*/_react.default.createElement(_thershold_indicator.ThresholdIndicator, {
      loading: loading,
      currentFormatted: (0, _data_formatting.formatMillisecond)(value, {}),
      current: value,
      previous: prevValue ? prevValue : null,
      previousFormatted: (0, _data_formatting.formatMillisecond)(prevValue !== null && prevValue !== void 0 ? prevValue : 0, {})
    })));
  })));
};
exports.BreakdownLegend = BreakdownLegend;