"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepImage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _journey_step_screenshot_container = require("../../common/screenshot/journey_step_screenshot_container");
var _last_successful_screenshot = require("./last_successful_screenshot");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepImage = ({
  step,
  ping,
  isFailed
}) => {
  var _step$synthetics, _step$synthetics$step, _step$synthetics$payl, _step$synthetics2, _step$synthetics2$ste;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const toggleButtons = [{
    id: `received`,
    label: RECEIVED_LABEL
  }, {
    id: `expected`,
    label: EXPECTED_LABEL
  }];
  const [idSelected, setIdSelected] = (0, _react.useState)(`received`);
  const onChangeDisabled = optionId => {
    setIdSelected(optionId);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, SCREENSHOT_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    css: {
      outline: 0,
      height: '192px',
      borderRadius: 0,
      display: 'flex',
      justifyContent: 'center'
    }
  }, idSelected === 'received' ? /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    checkGroup: step === null || step === void 0 ? void 0 : step.monitor.check_group,
    initialStepNumber: step === null || step === void 0 ? void 0 : (_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$step = _step$synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.index,
    stepStatus: step === null || step === void 0 ? void 0 : (_step$synthetics$payl = step.synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.status,
    allStepsLoaded: true,
    retryFetchOnRevisit: false,
    size: [260, 160],
    borderRadius: euiTheme.border.radius.small,
    timestamp: step === null || step === void 0 ? void 0 : step['@timestamp']
  }) : /*#__PURE__*/_react.default.createElement(_last_successful_screenshot.LastSuccessfulScreenshot, {
    step: ping,
    stepIndex: step === null || step === void 0 ? void 0 : (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index,
    size: [260, 160],
    borderRadius: euiTheme.border.radius.small
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isFailed && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "",
    options: toggleButtons,
    idSelected: idSelected,
    onChange: id => onChangeDisabled(id),
    buttonSize: "s",
    isFullWidth: true
  }));
};
exports.StepImage = StepImage;
const SCREENSHOT_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetails.screenshot', {
  defaultMessage: 'Screenshot'
});
const EXPECTED_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetails.expected', {
  defaultMessage: 'Expected'
});
const RECEIVED_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetails.received', {
  defaultMessage: 'Received'
});