"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorsDuration = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _formatting = require("../../../../../../utils/formatting");
var _state = require("../../../../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorsDuration = ({
  monitor,
  onClickDuration
}) => {
  const trendData = (0, _reactRedux.useSelector)(_state.selectOverviewTrends)[monitor.configId + monitor.locationId];
  const duration = trendData === 'loading' || !(trendData !== null && trendData !== void 0 && trendData.median) ? 0 : trendData.median;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    onClick: onClickDuration
  }, (0, _formatting.formatDuration)(duration));
};
exports.MonitorsDuration = MonitorsDuration;