"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorPings = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_selected_monitor = require("./use_selected_monitor");
var _use_selected_location = require("./use_selected_location");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorPings = props => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const location = (0, _use_selected_location.useSelectedLocation)();
  const monitorId = monitor === null || monitor === void 0 ? void 0 : monitor.id;
  const locationLabel = location === null || location === void 0 ? void 0 : location.label;
  const statusFilter = (0, _reactRedux.useSelector)(_state.selectStatusFilter);
  (0, _react.useEffect)(() => {
    if (monitorId && locationLabel) {
      dispatch(_state.getMonitorRecentPingsAction.get({
        monitorId,
        locationId: locationLabel,
        size: props === null || props === void 0 ? void 0 : props.pageSize,
        pageIndex: props === null || props === void 0 ? void 0 : props.pageIndex,
        from: props === null || props === void 0 ? void 0 : props.from,
        to: props === null || props === void 0 ? void 0 : props.to,
        statusFilter
      }));
    }
  }, [dispatch, monitorId, locationLabel, props === null || props === void 0 ? void 0 : props.lastRefresh, props === null || props === void 0 ? void 0 : props.pageSize, props === null || props === void 0 ? void 0 : props.pageIndex, props === null || props === void 0 ? void 0 : props.from, props === null || props === void 0 ? void 0 : props.to, statusFilter]);
  const {
    total,
    data: pings,
    loading
  } = (0, _reactRedux.useSelector)(_state.selectMonitorPingsMetadata);
  return {
    loading,
    total,
    pings
  };
};
exports.useMonitorPings = useMonitorPings;