"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloneMonitor = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _api = require("../../../state/monitor_details/api");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCloneMonitor = () => {
  const {
    cloneId
  } = (0, _hooks.useGetUrlParams)();
  return (0, _public.useFetcher)(() => {
    if (!cloneId) return Promise.resolve(undefined);
    return (0, _api.fetchSyntheticsMonitor)({
      monitorId: cloneId
    });
  }, [cloneId]);
};
exports.useCloneMonitor = useCloneMonitor;