"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverviewPanelTitle = exports.getMonitorsEmbeddableFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _rxjs = require("rxjs");
var _monitors_grid_component = require("./monitors_grid_component");
var _constants = require("../constants");
var _monitors_open_configuration = require("../common/monitors_open_configuration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOverviewPanelTitle = () => _i18n.i18n.translate('xpack.synthetics.monitors.displayName', {
  defaultMessage: 'Synthetics Monitors'
});
exports.getOverviewPanelTitle = getOverviewPanelTitle;
const DEFAULT_FILTERS = {
  projects: [],
  tags: [],
  locations: [],
  monitorIds: [],
  monitorTypes: []
};
const getMonitorsEmbeddableFactory = getStartServices => {
  const factory = {
    type: _constants.SYNTHETICS_MONITORS_EMBEDDABLE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      parentApi,
      uuid
    }) => {
      const [coreStart, pluginStart] = await getStartServices();
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const defaultTitle$ = new _rxjs.BehaviorSubject(getOverviewPanelTitle());
      const reload$ = new _rxjs.Subject();
      const filters$ = new _rxjs.BehaviorSubject(initialState.rawState.filters);
      const view$ = new _rxjs.BehaviorSubject(initialState.rawState.view);
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            filters: filters$.getValue(),
            view: view$.getValue()
          }
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        parentApi,
        uuid,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, filters$, view$).pipe((0, _rxjs.map)(() => undefined)),
        getComparators: () => ({
          ..._presentationPublishing.titleComparators,
          filters: 'referenceEquality',
          view: 'referenceEquality'
        }),
        defaultState: {
          filters: DEFAULT_FILTERS
        },
        onReset: lastSaved => {
          var _lastSaved$rawState$f;
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          filters$.next((_lastSaved$rawState$f = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.filters) !== null && _lastSaved$rawState$f !== void 0 ? _lastSaved$rawState$f : DEFAULT_FILTERS);
          if (lastSaved !== null && lastSaved !== void 0 && lastSaved.rawState) view$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.view);
        }
      });
      const api = finalizeApi({
        ...titleManager.api,
        ...unsavedChangesApi,
        defaultTitle$,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.synthetics.editSloOverviewEmbeddableTitle.typeDisplayName', {
          defaultMessage: 'filters'
        }),
        isEditingEnabled: () => true,
        serializeState,
        onEdit: async () => {
          try {
            const result = await (0, _monitors_open_configuration.openMonitorConfiguration)({
              coreStart,
              pluginStart,
              initialState: {
                filters: filters$.getValue() || DEFAULT_FILTERS,
                view: view$.getValue()
              },
              title: _i18n.i18n.translate('xpack.synthetics.editSyntheticsOverviewEmbeddableTitle.overview.title', {
                defaultMessage: 'Create monitors overview'
              }),
              type: _constants.SYNTHETICS_MONITORS_EMBEDDABLE
            });
            filters$.next(result.filters);
            view$.next(result.view);
          } catch (e) {
            return Promise.reject();
          }
        }
      });
      const fetchSubscription = (0, _presentationPublishing.fetch$)(api).pipe().subscribe(next => {
        reload$.next(next.isReload);
      });
      return {
        api,
        Component: () => {
          const [filters, view] = (0, _presentationPublishing.useBatchedPublishingSubjects)(filters$, view$);
          (0, _react.useEffect)(() => {
            return () => {
              fetchSubscription.unsubscribe();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement("div", {
            style: {
              width: '100%',
              maxHeight: '70vh',
              overflowY: 'auto'
            },
            "data-shared-item": "" // TODO: Remove data-shared-item and data-rendering-count as part of https://github.com/elastic/kibana/issues/179376
          }, /*#__PURE__*/_react.default.createElement(_monitors_grid_component.StatusGridComponent, {
            reload$: reload$,
            filters: filters || DEFAULT_FILTERS,
            view: view
          }));
        }
      };
    }
  };
  return factory;
};
exports.getMonitorsEmbeddableFactory = getMonitorsEmbeddableFactory;