"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSyntheticsSuggestions = useFetchSyntheticsSuggestions;
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSyntheticsSuggestions({
  filters,
  fieldName,
  search
}) {
  var _data$fieldName;
  const {
    http
  } = (0, _public2.useKibana)().services;
  const {
    locations,
    monitorIds,
    tags,
    projects
  } = filters || {};
  const {
    loading,
    data
  } = (0, _public.useFetcher)(async () => {
    return await http.get('/internal/synthetics/suggestions', {
      query: {
        locations: locations || [],
        monitorQueryIds: monitorIds || [],
        tags: tags || [],
        projects: projects || [],
        query: search
      }
    });
  }, [http, locations, monitorIds, projects, search, tags]);
  return {
    suggestions: (_data$fieldName = data === null || data === void 0 ? void 0 : data[fieldName]) !== null && _data$fieldName !== void 0 ? _data$fieldName : [],
    isLoading: Boolean(loading)
  };
}