"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validation = validation;
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createIs(_base, narrow) {
  return value => {
    return narrow.safeParse(value).success;
  };
}
function createAs(_base, _narrow) {
  return value => {
    return value;
  };
}
function createAsserts(_base, narrow) {
  return value => {
    narrow.parse(value);
    return true;
  };
}
function createParse(_base, narrow) {
  return value => {
    return narrow.parse(value);
  };
}
function validation(left, right) {
  const strict = (0, _zodHelpers.DeepStrict)(right);
  return {
    is: createIs(left, strict),
    as: createAs(left, strict),
    asserts: createAsserts(left, strict),
    parse: createParse(left, strict),
    left,
    right
  };
}