"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseStream = void 0;
var _zod = require("@kbn/zod");
var _queries = require("../queries");
var _model_validation = require("./validation/model_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/no-namespace */

const BaseStream = exports.BaseStream = (0, _model_validation.modelValidation)({
  Definition: _zod.z.object({
    name: _zod.z.string(),
    description: _zod.z.string()
  }),
  Source: _zod.z.object({}),
  GetResponse: _zod.z.object({
    dashboards: _zod.z.array(_zod.z.string()),
    queries: _zod.z.array(_queries.streamQuerySchema)
  }),
  UpsertRequest: _zod.z.object({
    dashboards: _zod.z.array(_zod.z.string()),
    queries: _zod.z.array(_queries.streamQuerySchema)
  })
});