"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamsStorageSettings = exports.StreamsService = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _lockManager = require("@kbn/lock-manager");
var _client = require("./client");
var _migrate_on_read = require("./helpers/migrate_on_read");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const streamsStorageSettings = exports.streamsStorageSettings = {
  name: '.kibana_streams',
  schema: {
    properties: {
      name: _storageAdapter.types.keyword(),
      description: _storageAdapter.types.text(),
      ingest: _storageAdapter.types.object({
        enabled: false
      }),
      group: _storageAdapter.types.object({
        enabled: false
      })
    }
  }
};
class StreamsService {
  constructor(coreSetup, logger, isDev) {
    this.coreSetup = coreSetup;
    this.logger = logger;
    this.isDev = isDev;
  }
  async getClientWithRequest({
    request,
    assetClient,
    queryClient
  }) {
    const [coreStart] = await this.coreSetup.getStartServices();
    const logger = this.logger;
    const scopedClusterClient = coreStart.elasticsearch.client.asScoped(request);
    const isServerless = coreStart.elasticsearch.getCapabilities().serverless;
    const storageAdapter = new _storageAdapter.StorageIndexAdapter(scopedClusterClient.asInternalUser, logger, streamsStorageSettings, {
      migrateSource: _migrate_on_read.migrateOnRead
    });
    return new _client.StreamsClient({
      assetClient,
      queryClient,
      logger,
      scopedClusterClient,
      lockManager: new _lockManager.LockManagerService(this.coreSetup, logger),
      storageClient: storageAdapter.getClient(),
      request,
      isServerless,
      isDev: this.isDev
    });
  }
}
exports.StreamsService = StreamsService;