"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ilmPhases = ilmPhases;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ilmPhases({
  policy,
  indicesIlmDetails,
  indicesStats
}) {
  const phaseWithName = (name, phase) => {
    if (!phase) return undefined;
    return {
      ...(0, _lodash.pick)(phase, ['min_age'], ['actions']),
      name
    };
  };
  const ilmDetails = Object.values(indicesIlmDetails);
  const phasesWithName = (0, _lodash.compact)([phaseWithName('hot', policy.phases.hot), phaseWithName('warm', policy.phases.warm), phaseWithName('cold', policy.phases.cold), phaseWithName('frozen', policy.phases.frozen), phaseWithName('delete', policy.phases.delete)]);
  return phasesWithName.reduce((phases, phase) => {
    var _phase$min_age;
    if (phase.name === 'delete') {
      phases[phase.name] = {
        name: phase.name,
        min_age: phase.min_age.toString()
      };
      return phases;
    }
    const sizeInBytes = ilmDetails.filter(detail => detail.managed && detail.phase === phase.name).map(detail => indicesStats[detail.index]).reduce((size, stats) => {
      var _stats$total$store$si, _stats$total, _stats$total$store;
      return size + ((_stats$total$store$si = stats === null || stats === void 0 ? void 0 : (_stats$total = stats.total) === null || _stats$total === void 0 ? void 0 : (_stats$total$store = _stats$total.store) === null || _stats$total$store === void 0 ? void 0 : _stats$total$store.size_in_bytes) !== null && _stats$total$store$si !== void 0 ? _stats$total$store$si : 0);
    }, 0);
    const policyPhase = {
      name: phase.name,
      size_in_bytes: sizeInBytes,
      min_age: (_phase$min_age = phase.min_age) === null || _phase$min_age === void 0 ? void 0 : _phase$min_age.toString()
    };
    if (phase.name === 'hot') {
      var _phase$actions, _phase$actions2, _phase$actions2$rollo, _phase$actions3, _phase$actions3$rollo, _phase$actions4, _phase$actions4$rollo, _phase$actions5, _phase$actions5$rollo;
      const rollover = (_phase$actions = phase.actions) === null || _phase$actions === void 0 ? void 0 : _phase$actions.rollover;
      const maxAge = !(rollover !== null && rollover !== void 0 && rollover.max_age) || (rollover === null || rollover === void 0 ? void 0 : rollover.max_age) === -1 ? undefined : rollover.max_age;
      phases[phase.name] = {
        ...policyPhase,
        name: 'hot',
        rollover: {
          max_age: maxAge,
          max_size: (_phase$actions2 = phase.actions) === null || _phase$actions2 === void 0 ? void 0 : (_phase$actions2$rollo = _phase$actions2.rollover) === null || _phase$actions2$rollo === void 0 ? void 0 : _phase$actions2$rollo.max_size,
          max_primary_shard_size: (_phase$actions3 = phase.actions) === null || _phase$actions3 === void 0 ? void 0 : (_phase$actions3$rollo = _phase$actions3.rollover) === null || _phase$actions3$rollo === void 0 ? void 0 : _phase$actions3$rollo.max_primary_shard_size,
          max_docs: (_phase$actions4 = phase.actions) === null || _phase$actions4 === void 0 ? void 0 : (_phase$actions4$rollo = _phase$actions4.rollover) === null || _phase$actions4$rollo === void 0 ? void 0 : _phase$actions4$rollo.max_docs,
          max_primary_shard_docs: (_phase$actions5 = phase.actions) === null || _phase$actions5 === void 0 ? void 0 : (_phase$actions5$rollo = _phase$actions5.rollover) === null || _phase$actions5$rollo === void 0 ? void 0 : _phase$actions5$rollo.max_primary_shard_docs
        }
      };
    } else {
      phases[phase.name] = policyPhase;
    }
    return phases;
  }, {});
}