"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteIngestPipeline = deleteIngestPipeline;
exports.upsertIngestPipeline = upsertIngestPipeline;
var _retry = require("../helpers/retry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteIngestPipeline({
  esClient,
  id,
  logger
}) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.ingest.deletePipeline({
      id
    }, {
      ignore: [404]
    }), {
      logger
    });
  } catch (error) {
    logger.error(`Error deleting ingest pipeline: ${error.message}`);
    throw error;
  }
}
async function upsertIngestPipeline({
  esClient,
  pipeline,
  logger
}) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.ingest.putPipeline(pipeline), {
      logger
    });
    logger.debug(() => `Installed ingest pipeline: ${JSON.stringify(pipeline)}`);
  } catch (error) {
    logger.error(`Error updating ingest pipeline: ${error.message}`);
    throw error;
  }
}