"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRootStreamChanges = validateRootStreamChanges;
var _streamsSchema = require("@kbn/streams-schema");
var _lodash = require("lodash");
var _malformed_stream_error = require("../errors/malformed_stream_error");
var _root_stream_immutability_error = require("../errors/root_stream_immutability_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Changes to mappings (fields) and processing rules are not allowed on the root stream.
 * Changes to routing rules are allowed.
 * Root stream cannot inherit a lifecycle.
 */
function validateRootStreamChanges(currentStreamDefinition, nextStreamDefinition) {
  const hasFieldChanges = !(0, _lodash.isEqual)(currentStreamDefinition.ingest.wired.fields, nextStreamDefinition.ingest.wired.fields);
  if (hasFieldChanges) {
    throw new _root_stream_immutability_error.RootStreamImmutabilityError('Root stream fields cannot be changed');
  }
  const hasProcessingChanges = !(0, _lodash.isEqual)(currentStreamDefinition.ingest.processing, nextStreamDefinition.ingest.processing);
  if (hasProcessingChanges) {
    throw new _root_stream_immutability_error.RootStreamImmutabilityError('Root stream processing rules cannot be changed');
  }
  if ((0, _streamsSchema.isInheritLifecycle)(nextStreamDefinition.ingest.lifecycle)) {
    throw new _malformed_stream_error.MalformedStreamError('Root stream cannot inherit lifecycle');
  }
}