"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateOnRead = migrateOnRead;
var _streamsSchema = require("@kbn/streams-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function migrateOnRead(definition) {
  let migratedDefinition = definition;
  if (typeof definition.description !== 'string') {
    migratedDefinition = {
      ...definition,
      description: ''
    };
  }
  _streamsSchema.Streams.all.Definition.asserts(migratedDefinition);
  return migratedDefinition;
}