"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRules = registerRules;
var _common = require("@kbn/alerting-plugin/common");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _server = require("@kbn/rule-registry-plugin/server");
var _constants = require("../../../common/constants");
var _register = require("./esql/register");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRules({
  plugins,
  logger
}) {
  const ruleDataClient = plugins.ruleRegistry.ruleDataService.initializeIndex({
    feature: _constants.STREAMS_FEATURE_ID,
    registrationContext: _constants.STREAMS_RULE_REGISTRATION_CONTEXT,
    dataset: _server.Dataset.alerts,
    componentTemplateRefs: [],
    componentTemplates: [{
      name: 'mappings',
      mappings: (0, _common.mappingFromFieldMap)(_alertsAsDataUtils.alertFieldMap, false)
    }]
  });
  const persistenceRuleTypeWrapper = (0, _server.createPersistenceRuleTypeWrapper)({
    ruleDataClient,
    logger,
    formatAlert: undefined
  });
  plugins.alerting.registerType(persistenceRuleTypeWrapper((0, _register.esqlRuleType)()));
}