"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlResultToTimeseries = esqlResultToTimeseries;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function esqlResultToTimeseries({
  result,
  metricNames
}) {
  var _result$value, _result$value2;
  const columns = (_result$value = result.value) === null || _result$value === void 0 ? void 0 : _result$value.columns;
  const rows = (_result$value2 = result.value) === null || _result$value2 === void 0 ? void 0 : _result$value2.values;
  if (!(columns !== null && columns !== void 0 && columns.length) || !(rows !== null && rows !== void 0 && rows.length)) {
    return [];
  }
  const timestampColumn = columns.find(col => col.name === '@timestamp');
  if (!timestampColumn) {
    return [];
  }
  const collectedSeries = new Map();
  rows.forEach(columnsInRow => {
    const values = new Map();
    const labels = new Map();
    let timestamp;
    columnsInRow.forEach((value, index) => {
      const column = columns[index];
      const isTimestamp = column.name === '@timestamp';
      const isMetric = metricNames.indexOf(column.name) !== -1;
      if (isTimestamp) {
        timestamp = new Date(value).getTime();
      } else if (isMetric) {
        values.set(column.name, value);
      } else {
        labels.set(column.name, String(value));
      }
    });
    const seriesKey = Array.from(labels.entries()).map(([key, value]) => [key, value].join(':')).sort().join(',') || '-';
    if (!collectedSeries.has(seriesKey)) {
      collectedSeries.set(seriesKey, {
        id: seriesKey,
        data: [],
        label: seriesKey,
        metricNames
      });
    }
    const series = collectedSeries.get(seriesKey);
    const coordinate = {
      x: timestamp
    };
    values.forEach((value, key) => {
      if (key !== 'x') {
        // @ts-expect-error
        coordinate[key] = value;
      }
    });
    series.data.push(coordinate);
    return collectedSeries;
  });
  return Array.from(collectedSeries.entries()).map(([id, timeseries]) => {
    return {
      ...timeseries,
      data: (0, _lodash.orderBy)(timeseries.data, 'x', 'asc')
    };
  });
}