"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailRoot = StreamDetailRoot;
var _react = _interopRequireDefault(require("react"));
var _use_stream_detail = require("../../hooks/use_stream_detail");
var _use_streams_app_breadcrumbs = require("../../hooks/use_streams_app_breadcrumbs");
var _use_streams_app_params = require("../../hooks/use_streams_app_params");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamDetailRoot({
  children
}) {
  const {
    streamsRepositoryClient
  } = (0, _use_kibana.useKibana)().dependencies.start.streams;
  const {
    path: {
      key
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}', true);
  (0, _use_streams_app_breadcrumbs.useStreamsAppBreadcrumbs)(() => {
    return [{
      title: key,
      path: `/{key}`,
      params: {
        path: {
          key
        }
      }
    }];
  }, [key]);
  return /*#__PURE__*/_react.default.createElement(_use_stream_detail.StreamDetailContextProvider, {
    name: key,
    streamsRepositoryClient: streamsRepositoryClient
  }, children);
}