"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentPackMetadata = ContentPackMetadata;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ContentPackMetadata({
  manifest,
  readonly,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: readonly,
    prepend: 'Name',
    fullWidth: true,
    value: manifest.name,
    isInvalid: manifest.name.length === 0,
    onChange: e => onChange === null || onChange === void 0 ? void 0 : onChange({
      ...manifest,
      name: e.target.value
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: readonly,
    prepend: 'Version',
    fullWidth: true,
    value: manifest.version,
    onChange: e => onChange === null || onChange === void 0 ? void 0 : onChange({
      ...manifest,
      version: e.target.value
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: readonly,
    prepend: 'Description',
    fullWidth: true,
    value: manifest.description,
    onChange: e => onChange === null || onChange === void 0 ? void 0 : onChange({
      ...manifest,
      description: e.target.value
    })
  })));
}