"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoutingStreamEntry = RoutingStreamEntry;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _css = require("@emotion/css");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _condition_editor = require("../condition_editor");
var _condition_message = require("../condition_message");
var _control_bars = require("./control_bars");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RoutingStreamEntry({
  availableStreams,
  draggableProvided,
  isEditing,
  isEditingEnabled,
  onChange,
  onEditIconClick,
  routingRule
}) {
  const theme = (0, _eui.useEuiTheme)();
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const childrenCount = availableStreams.filter(stream => (0, _streamsSchema.isDescendantOf)(routingRule.destination, stream)).length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    color: (0, _streamsSchema.isNeverCondition)(routingRule.if) ? 'transparent' : undefined,
    paddingSize: "s",
    className: (0, _css.css)`
        overflow: hidden;
        .streamsDragHandle {
          transition: margin-left ${theme.euiTheme.animation.normal};
          padding: ${theme.euiTheme.size.s} 0;
          margin-left: -${theme.euiTheme.size.l};
        }
        &:hover .streamsDragHandle {
          margin-left: 0;
        }
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    className: "streamsDragHandle",
    color: "transparent",
    paddingSize: "s"
  }, draggableProvided.dragHandleProps, {
    "aria-label": _i18n.i18n.translate('xpack.streams.routingStreamEntry.euiPanel.dragHandleLabel', {
      defaultMessage: 'Drag Handle'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grabOmnidirectional"
  }))), (0, _streamsSchema.isNeverCondition)(routingRule.if) && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.disabled', {
    defaultMessage: 'Disabled'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: router.link('/{key}/management/{tab}', {
      path: {
        key: routingRule.destination,
        tab: 'route'
      }
    }),
    "data-test-subj": "streamsAppRoutingStreamEntryButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, routingRule.destination)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _css.css)`
            overflow: hidden;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    size: "s",
    color: "subdued",
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_condition_message.ConditionMessage, {
    condition: routingRule.if
  }))), childrenCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.numberChildren', {
    defaultMessage: '{childrenCount, plural, one {# child} other {# children}}',
    values: {
      childrenCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppRoutingStreamEntryButton",
    iconType: "pencil",
    disabled: !isEditingEnabled,
    onClick: () => onEditIconClick(routingRule.id),
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailRouting.edit', {
      defaultMessage: 'Edit'
    })
  })), isEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_condition_editor.RoutingConditionEditor, {
    condition: routingRule.if,
    onConditionChange: condition => onChange({
      if: condition
    })
  }), /*#__PURE__*/_react.default.createElement(_control_bars.EditRoutingRuleControls, {
    relatedStreams: availableStreams.filter(streamName => streamName === routingRule.destination || (0, _streamsSchema.isDescendantOf)(routingRule.destination, streamName)),
    routingRule: routingRule
  })));
}