"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChildStreamList = ChildStreamList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _nested_view = require("../../nested_view");
var _current_stream_entry = require("./current_stream_entry");
var _new_routing_stream_entry = require("./new_routing_stream_entry");
var _routing_stream_entry = require("./routing_stream_entry");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChildStreamList({
  availableStreams
}) {
  const {
    changeRule,
    createNewRule,
    editRule,
    reorderRules
  } = (0, _stream_routing_state_machine.useStreamRoutingEvents)();
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  const {
    currentRuleId,
    definition,
    routing
  } = routingSnapshot.context;
  const canCreateRoutingRules = routingSnapshot.can({
    type: 'routingRule.create'
  });
  const canReorderRoutingRules = routingSnapshot.can({
    type: 'routingRule.reorder',
    routing
  });
  const canManageRoutingRules = definition.privileges.manage;
  const shouldDisplayCreateButton = definition.privileges.simulate;
  const handlerItemDrag = ({
    source,
    destination
  }) => {
    if (source && destination) {
      const items = (0, _eui.euiDragDropReorder)(routing, source.index, destination.index);
      reorderRules(items);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    className: (0, _css.css)`
        overflow: auto;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    wrap: true,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: (0, _css.css)`
              height: 40px;
              align-content: center;
              font-weight: bold;
            `
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.rules.header', {
    defaultMessage: 'Routing rules'
  })), shouldDisplayCreateButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !canManageRoutingRules ? _i18n.i18n.translate('xpack.streams.streamDetailRouting.rules.onlySimulate', {
      defaultMessage: "You don't have sufficient privileges to create new streams, only simulate."
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plus",
    size: "s",
    "data-test-subj": "streamsAppStreamDetailRoutingAddRuleButton",
    onClick: createNewRule,
    disabled: !canCreateRoutingRules
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.addRule', {
    defaultMessage: 'Create child stream'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    className: (0, _css.css)`
          overflow: auto;
        `
  }, /*#__PURE__*/_react.default.createElement(_current_stream_entry.CurrentStreamEntry, {
    definition: definition
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: handlerItemDrag
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "routing_children_reordering",
    spacing: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, routing.map((routingRule, pos) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: routingRule.id,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    index: pos,
    isDragDisabled: !canReorderRoutingRules,
    draggableId: routingRule.id,
    hasInteractiveChildren: true,
    customDragHandle: true,
    spacing: "none"
  }, (provided, snapshot) => /*#__PURE__*/_react.default.createElement(_nested_view.NestedView, {
    last: pos === routing.length - 1,
    isBeingDragged: snapshot.isDragging
  }, routingRule.isNew ? /*#__PURE__*/_react.default.createElement(_new_routing_stream_entry.NewRoutingStreamEntry, null) : /*#__PURE__*/_react.default.createElement(_routing_stream_entry.RoutingStreamEntry, {
    availableStreams: availableStreams,
    draggableProvided: provided,
    isEditing: currentRuleId === routingRule.id,
    isEditingEnabled: routingSnapshot.can({
      type: 'routingRule.edit',
      id: routingRule.id
    }),
    onChange: changeRule,
    onEditIconClick: editRule,
    routingRule: routingRule
  }))))))))));
}