"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateTimezoneField = exports.DateTargetField = exports.DateOutputFormatField = exports.DateLocaleField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DateTargetField = () => {
  const {
    register
  } = (0, _reactHookForm.useFormContext)();
  const {
    ref,
    ...inputProps
  } = register('target_field');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dateTargetLabel', {
      defaultMessage: 'Target field'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateTargetHelpText",
      defaultMessage: "The field that will hold the parsed date. Defaults to {target}.",
      values: {
        target: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "@timestamp")
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, inputProps, {
    inputRef: ref
  })));
};
exports.DateTargetField = DateTargetField;
const DateTimezoneField = () => {
  const {
    register
  } = (0, _reactHookForm.useFormContext)();
  const {
    ref,
    ...inputProps
  } = register('timezone');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dateTimezoneLabel', {
      defaultMessage: 'Timezone'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateTimezoneHelpText",
      defaultMessage: "The timezone to use when parsing the date. Supports template snippets. Defaults to {timezone}",
      values: {
        timezone: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "UTC")
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, inputProps, {
    inputRef: ref
  })));
};
exports.DateTimezoneField = DateTimezoneField;
const DateLocaleField = () => {
  const {
    register
  } = (0, _reactHookForm.useFormContext)();
  const {
    ref,
    ...inputProps
  } = register('locale');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dateLocaleLabel', {
      defaultMessage: 'Locale'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateLocaleHelpText",
      defaultMessage: "The locale to use when parsing the date, relevant when parsing month names or week days. Supports template snippets. Defaults to {locale}.",
      values: {
        locale: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "ENGLISH")
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, inputProps, {
    inputRef: ref
  })));
};
exports.DateLocaleField = DateLocaleField;
const DateOutputFormatField = () => {
  const {
    register
  } = (0, _reactHookForm.useFormContext)();
  const {
    ref,
    ...inputProps
  } = register('output_format');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dateOutputFormatLabel', {
      defaultMessage: 'Output format'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateOutputFormatHelpText",
      defaultMessage: "The format to use when writing the date to {field}. Must be a valid java time pattern. Defaults to {outputFormat}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "target_field"),
        outputFormat: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, inputProps, {
    inputRef: ref
  })));
};
exports.DateOutputFormatField = DateOutputFormatField;