"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userAgentProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFormState = {
  type: 'user_agent',
  field: '',
  target_field: '',
  regex_file: '',
  properties: [],
  ignore_missing: false
};
const fieldOptions = {
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.userAgentFieldHelpText', {
    defaultMessage: 'The field containing the user agent string.'
  }),
  includeCondition: false,
  includeIgnoreFailures: false,
  includeIgnoreMissing: true
};
const fieldConfigurations = [{
  field: 'target_field',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.userAgentTargetFieldLabel', {
    defaultMessage: 'Target field'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.userAgentTargetFieldHelpText",
    defaultMessage: "The field that will be filled with the user agent details. Default is {userAgentField}.",
    values: {
      userAgentField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "user_agent")
    }
  })
}, {
  field: 'regex_file',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.userAgentRegexFileLabel', {
    defaultMessage: 'Regex file'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.userAgentRegexFileHelpText",
    defaultMessage: "The name of the file in the config/ingest-user-agent directory containing the regular expressions for parsing the user agent string. Both the directory and the file have to be created before starting Elasticsearch. If not specified, ingest-user-agent will use the regexes.yaml from uap-core it ships with."
  })
}, {
  field: 'properties',
  type: 'array',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.userAgentPropertiesLabel', {
    defaultMessage: 'Properties'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.userAgentPropertiesHelpText",
    defaultMessage: "Controls what properties are added to {targetField}.",
    values: {
      targetField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "target_field")
    }
  })
}];
const userAgentProcessorConfig = exports.userAgentProcessorConfig = {
  type: 'user_agent',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.UserAgentInputDisplay', {
    defaultMessage: 'User agent'
  }),
  getDocUrl: esDocUrl => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.userAgentHelpText",
      defaultMessage: "{userAgentLink} extracts details from the user agent string a browser sends with its web requests. This processor adds this information by default under the {userAgentField} field.",
      values: {
        userAgentLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsUserAgentLink",
          external: true,
          target: "_blank",
          href: esDocUrl + 'user-agent-processor.html'
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.userAgentLinkLabel', {
          defaultMessage: 'The user_agent processor'
        })),
        userAgentField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "user_agent")
      }
    });
  },
  defaultFormState,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)('user_agent', fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)('user_agent', defaultFormState),
  fieldConfigurations,
  fieldOptions
};