"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourcesList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react2 = require("@emotion/react");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _data_source_state_machine = require("./state_management/data_source_state_machine");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataSourcesFlyout = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./data_sources_flyout'))).then(mod => ({
  default: mod.DataSourcesFlyout
})));
const VISIBLE_DATA_SOURCES_LIMIT = 2;
const DATA_SOURCE_CARD_MAX_WIDTH = 160;
const manageDataSourcesLabel = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.openDataSourcesManagement.label', {
  defaultMessage: 'Manage data sources'
});
const DataSourcesList = () => {
  const {
    closeDataSourcesManagement,
    openDataSourcesManagement
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const isManagingDataSources = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      enrichment: {
        managingDataSources: 'open'
      }
    }
  }));
  const dataSourcesRefs = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.dataSourcesRefs);
  const visibleDataSourcesRefs = dataSourcesRefs.slice(0, VISIBLE_DATA_SOURCES_LIMIT);
  const hiddenDataSourcesRefs = dataSourcesRefs.slice(VISIBLE_DATA_SOURCES_LIMIT);
  const hasHiddenDataSources = hiddenDataSourcesRefs.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: false,
    alignItems: "center",
    gutterSize: "s"
  }, visibleDataSourcesRefs.map(dataSourceRef => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: dataSourceRef.id,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(DataSourceListItem, {
    dataSourceRef: dataSourceRef
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: manageDataSourcesLabel
  }, hasHiddenDataSources ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "controls",
    iconSide: "right",
    onClick: openDataSourcesManagement,
    "aria-label": manageDataSourcesLabel,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    size: "m"
  }, "+", hiddenDataSourcesRefs.length)) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "controls",
    onClick: openDataSourcesManagement,
    "aria-label": manageDataSourcesLabel,
    size: "s"
  })))), isManagingDataSources && /*#__PURE__*/_react.default.createElement(DataSourcesFlyout, {
    onClose: closeDataSourcesManagement
  }));
};
exports.DataSourcesList = DataSourcesList;
const DataSourceListItem = ({
  dataSourceRef
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dataSourceState = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot);
  const isEnabled = dataSourceState.matches('enabled');
  const toggleActivity = () => {
    dataSourceRef.send({
      type: 'dataSource.toggleActivity'
    });
  };
  const content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    css: (0, _react2.css)`
        max-width: ${DATA_SOURCE_CARD_MAX_WIDTH}px;
      `
  }, /*#__PURE__*/_react.default.createElement("strong", {
    className: "eui-textTruncate",
    css: (0, _react2.css)`
          font-weight: ${euiTheme.font.weight.semiBold};
        `
  }, dataSourceState.context.dataSource.name || dataSourceState.context.dataSource.type), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "span",
    size: "s",
    color: "subdued"
  }, "(", dataSourceState.context.data.length, ")"));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: dataSourceRef.id,
    label: content,
    checked: isEnabled,
    onChange: toggleActivity
  }));
};