"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppRoot = AppRoot;
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _react = _interopRequireDefault(require("react"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _streams_app_context_provider = require("../streams_app_context_provider");
var _config = require("../../routes/config");
var _kbn_url_state_context = require("../../util/kbn_url_state_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AppRoot({
  coreStart,
  pluginsStart,
  services,
  appMountParameters,
  isServerless
}) {
  const {
    history
  } = appMountParameters;
  const context = {
    appParams: appMountParameters,
    core: coreStart,
    dependencies: {
      start: pluginsStart
    },
    services,
    isServerless
  };
  return /*#__PURE__*/_react.default.createElement(_streams_app_context_provider.StreamsAppContextProvider, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: coreStart
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _config.streamsAppRouter
  }, /*#__PURE__*/_react.default.createElement(_kbn_url_state_context.KbnUrlStateStorageFromRouterProvider, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.BreadcrumbsContextProvider, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouteRenderer, null))))));
}