"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _thehive = require("./thehive");
var _schema = require("../../../common/thehive/schema");
var _constants = require("../../../common/thehive/constants");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConnectorType() {
  return {
    id: _constants.THEHIVE_CONNECTOR_ID,
    minimumLicenseRequired: 'platinum',
    name: _constants.THEHIVE_TITLE,
    getService: params => new _thehive.TheHiveConnector(params, _schema.PushToServiceIncidentSchema),
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.SecurityConnectorFeatureId, _common.UptimeConnectorFeatureId, _common.CasesConnectorFeatureId],
    schema: {
      config: _schema.TheHiveConfigSchema,
      secrets: _schema.TheHiveSecretsSchema
    },
    renderParameterTemplates: _render.renderParameterTemplates,
    validators: [{
      type: _types.ValidatorType.CONFIG,
      validator: (0, _server.urlAllowListValidator)('url')
    }]
  };
}