"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRecordMaxKeys = exports.validateKeysAllowed = exports.FIELDS_MAX_LENGTH_ERROR = exports.FIELDS_KEY_NOT_ALLOWED_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELDS_MAX_LENGTH_ERROR = (length, fieldName) => _i18n.i18n.translate('xpack.stackConnectors.schema.otherFieldsLengthError', {
  values: {
    length,
    fieldName
  },
  defaultMessage: 'A maximum of {length, plural, =1 {{length} field} other {{length} fields}} in {fieldName} can be defined at a time.'
});
exports.FIELDS_MAX_LENGTH_ERROR = FIELDS_MAX_LENGTH_ERROR;
const FIELDS_KEY_NOT_ALLOWED_ERROR = (properties, fieldName) => _i18n.i18n.translate('xpack.stackConnectors.schema.otherFieldsPropertyError', {
  values: {
    properties,
    fieldName
  },
  defaultMessage: 'The following properties cannot be defined inside {fieldName}: {properties}.'
});
exports.FIELDS_KEY_NOT_ALLOWED_ERROR = FIELDS_KEY_NOT_ALLOWED_ERROR;
const validateRecordMaxKeys = ({
  record,
  maxNumberOfFields,
  fieldName
}) => {
  if (Object.keys(record).length > maxNumberOfFields) {
    return FIELDS_MAX_LENGTH_ERROR(maxNumberOfFields, fieldName);
  }
};
exports.validateRecordMaxKeys = validateRecordMaxKeys;
const validateKeysAllowed = ({
  key,
  disallowList,
  fieldName
}) => {
  const propertiesSet = new Set(disallowList);
  if (propertiesSet.has(key)) {
    return FIELDS_KEY_NOT_ALLOWED_ERROR(key, fieldName);
  }
};
exports.validateKeysAllowed = validateKeysAllowed;