"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCrowdstrikeConnectorType = void 0;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _feature = require("@kbn/actions-plugin/server/feature");
var _constants = require("../../../common/crowdstrike/constants");
var _schema = require("../../../common/crowdstrike/schema");
var _crowdstrike = require("./crowdstrike");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCrowdstrikeConnectorType = experimentalFeatures => ({
  id: _constants.CROWDSTRIKE_CONNECTOR_ID,
  name: _constants.CROWDSTRIKE_TITLE,
  getService: params => new _crowdstrike.CrowdstrikeConnector(params, experimentalFeatures),
  schema: {
    config: _schema.CrowdstrikeConfigSchema,
    secrets: _schema.CrowdstrikeSecretsSchema
  },
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: (0, _server.urlAllowListValidator)('url')
  }],
  supportedFeatureIds: [_common.EndpointSecurityConnectorFeatureId],
  minimumLicenseRequired: 'enterprise',
  subFeature: 'endpointSecurity',
  getKibanaPrivileges: args => {
    var _args$params;
    const privileges = [_feature.ENDPOINT_SECURITY_EXECUTE_PRIVILEGE];
    if ((args === null || args === void 0 ? void 0 : args.source) === _server.ActionExecutionSourceType.HTTP_REQUEST && (args === null || args === void 0 ? void 0 : (_args$params = args.params) === null || _args$params === void 0 ? void 0 : _args$params.subAction) !== _constants.SUB_ACTION.GET_AGENT_DETAILS) {
      privileges.push(_feature.ENDPOINT_SECURITY_SUB_ACTIONS_EXECUTE_PRIVILEGE);
    }
    return privileges;
  }
});
exports.getCrowdstrikeConnectorType = getCrowdstrikeConnectorType;